/*
 * @(#)AllActionListener.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.Vector;


/**
 * implements ActionListener methods
 * This class perform the dispatch, it depend of the action
 * @see Zip
 * @see ZipAbout
 */
class AllActionListener implements ActionListener {

    // private member
    private Zip zip;


    /**
     * The constructor of the class
     * @param zip it is the accessor of the zip class
     */
    public AllActionListener(Zip zip) {
	this.zip = zip;
    }


    /**
     * Method use for dispatch the actions
     * @param e the action to dispatch
     */
    public void actionPerformed(ActionEvent e) {

	// the action string
	String theAction = e.getActionCommand();

	// test the action string and call the zip methods
	if(theAction.equals("Quit")) {
	    System.exit(0);
	} else if(theAction.equals("Open")) {
	    zip.openZipArchive();
	} else if(theAction.equals("New")) {
	    zip.newZipArchive();
	} else if(theAction.equals("Extract")) {
	    zip.extractSelectedFiles();
	} else if(theAction.equals("Add")) {
	    zip.selectAndAddFiles();
	} else if(theAction.equals("Delete")) {
	    zip.deleteSelectedFiles();
	} else if(theAction.equals("SelectNone")) {
	    zip.selectNone();
	} else if(theAction.equals("SelectAll")) {
	    zip.selectAll();
	} else if(theAction.equals("ExtractAll")) {
	    zip.selectAll();
	    zip.extractSelectedFiles();
	} else if(theAction.equals("Windows")) {
	    zip.selectStyle("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
	} else if(theAction.equals("Motif")) {
	    zip.selectStyle("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
	} else if(theAction.equals("Metal")) {
	    zip.selectStyle("com.sun.java.swing.plaf.metal.MetalLookAndFeel");
	} else if(theAction.equals("About")) {
	    new ZipAbout(zip,"About Zip");
	} else {
	    System.out.println(theAction + " has no effect");
	}
    }
}
